#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "common.h"
#include "error.h"

extern char* yytext;

int line_number;

CLog		theLog;

//****************************************************************************************************************
//Fce ktera je implicitne vyzadovana parserem ktery vygenroval bison, musi se takhle jmenovat, jake ma telo uz je
//jedno, ale asi by melo hlasit chybu na nejaky vystup :). Take je pouzita lexiklanim skenerem ktery vygeneroval flex
//****************************************************************************************************************
void yyerror(const char* format, ...)
{
	va_list argList;

	va_start(argList,format);
	vfprintf(stderr, format, argList);
	va_end(argList);

	fprintf(stderr,"\n");
	fprintf(stderr,"*** Syntax error before %s at line %i\n",yytext,line_number);
	fprintf(stderr,"Compilation terminated!");

	exit(1);
}
//****************************************************************************************************************
//konstruktor
//****************************************************************************************************************
CLog::CLog()
{
	m_LogFile = NULL;
	m_errors = 0;
}
//****************************************************************************************************************
//Destruktor
//****************************************************************************************************************
CLog::~CLog()
{
	if (m_LogFile)
	{
		//zavri soubor pokud je otevren ale nejdriv tam vypis ukoncovaci html tagy
		fprintf(m_LogFile,LOG_BODY_END);
		fclose(m_LogFile);
	}
}
//****************************************************************************************************************
//fce pro otevreni log souboru
//****************************************************************************************************************
HRESULT CLog::OpenLogFile(const char* name)
{
	m_LogFile = fopen(name,"w");
	if (!m_LogFile)				//vrat chybu, spatny ukazatel pokud se nepodari otevrit soubor
		return E_POINTER;

	//zapis pocatecni html tagy, nebot logovaci soubor ma format html stranky
	fprintf(m_LogFile,LOG_HEADER_0);
	fprintf(m_LogFile,"%s",name);
	fprintf(m_LogFile,LOG_HEADER_1);
	return S_OK;
}
//****************************************************************************************************************
//Hlaseni chyby
//****************************************************************************************************************
void CLog::ReportError(int linenumber, const char* format, ...)
{
	va_list argList;

	fprintf(stderr,"Error: ");
	fprintf(m_LogFile,"Error: ");

	va_start(argList,format);
	vfprintf(stderr,format,argList);
	va_end(argList);

	va_start(argList,format);
	vfprintf(m_LogFile,format,argList);
	va_end(argList);

	fprintf(stderr," at line %i\n",linenumber);
	fprintf(m_LogFile," at line %i<br>",linenumber);

	m_errors++;
}
//****************************************************************************************************************
//hlaseni varovani
//****************************************************************************************************************
void CLog::ReportWarning(int linenumber, const char* format, ...)
{
	va_list argList;

	fprintf(stderr,"Warning: ");
	fprintf(m_LogFile,"Warning: ");

	va_start(argList,format);
	vfprintf(stderr,format,argList);
	va_end(argList);

	va_start(argList,format);
	vfprintf(m_LogFile,format,argList);
	va_end(argList);

	fprintf(stderr," at line %i\n", linenumber);
	fprintf(m_LogFile," at line %i<br>",linenumber);
}
//****************************************************************************************************************
//kontrola poctu chyb
//****************************************************************************************************************
void CLog::ErrorCheck()
{
	if (m_errors != 0)
	{
		fprintf(stderr,"*** %i error(s) encountered, compilation terminated***\n",m_errors);
		fprintf(m_LogFile,"*** %i error(s) encountered, compilation terminated***<br>",m_errors);
		exit(1);
	}
}
//****************************************************************************************************************
//vypis zpravy do konzole a souboru
//****************************************************************************************************************
void CLog::TraceCF(const char* format,...)
{
	va_list argList;

	va_start(argList,format);
	vfprintf(stderr,format,argList);
	va_end(argList);

	va_start(argList,format);
	vfprintf(m_LogFile,format,argList);
	va_end(argList);
}
//****************************************************************************************************************
//vypis zpravy do konzole
//****************************************************************************************************************
void CLog::TraceC(const char* format,...)
{
	va_list argList;

	va_start(argList,format);
	vfprintf(stderr,format,argList);
	va_end(argList);
}
//****************************************************************************************************************
//vypis zpravy do souboru
//****************************************************************************************************************
void CLog::TraceF(const char* format,...)
{
	va_list argList;

	va_start(argList,format);
	vfprintf(m_LogFile,format,argList);
	va_end(argList);
}

